# 🚀 Quick Setup Guide - Postry Social Media Admin Panel

## ✅ What's Already Done

1. ✅ Firebase configuration updated with your credentials
2. ✅ Service account key file copied to backend folder
3. ✅ All Firebase backend files created
4. ✅ Security and routing configured

## 📋 Next Steps to Complete Setup

### Step 1: Install Composer (if not installed)

**Windows:**
1. Download Composer from: https://getcomposer.org/Composer-Setup.exe
2. Run the installer
3. Restart your command prompt

**Or use XAMPP/WAMP:**
- XAMPP/WAMP usually comes with Composer pre-installed

### Step 2: Install PHP Dependencies

Open command prompt in backend folder and run:
```bash
composer install
```

**If composer is not available, manually download these files:**
1. Create `vendor` folder in backend directory
2. Download Firebase PHP SDK manually from GitHub

### Step 3: Test Firebase Connection

Create a test file `test_firebase.php` in backend folder:

```php
<?php
require_once __DIR__ . '/firebase_config.php';

try {
    $firestore = FirebaseConfig::getFirestore();
    echo "✅ Firebase connection successful!\n";
    echo "✅ Project ID: " . FirebaseConfig::FIREBASE_CONFIG['projectId'] . "\n";
} catch (Exception $e) {
    echo "❌ Firebase connection failed: " . $e->getMessage() . "\n";
}
?>
```

Run: `php test_firebase.php`

### Step 4: Create Admin User

```bash
curl -X POST http://localhost/backend/firebase_auth.php?action=create_admin \
  -H "Content-Type: application/json" \
  -d "{\"email\":\"admin@postry.com\",\"password\":\"admin123\"}"
```

### Step 5: Test Login

```bash
curl -X POST http://localhost/backend/firebase_auth.php?action=login \
  -H "Content-Type: application/json" \
  -d "{\"email\":\"admin@postry.com\",\"password\":\"admin123\"}"
```

### Step 6: Test Dashboard

```bash
curl -X GET http://localhost/backend/firebase_dashboard.php \
  -H "Authorization: Bearer YOUR_TOKEN_HERE"
```

## 🔧 Your Firebase Project Details

- **Project ID:** postry-social-media
- **Project Name:** Postry Social Media
- **Service Account:** firebase-adminsdk-fbsvc@postry-social-media.iam.gserviceaccount.com
- **Database:** Firestore
- **Storage:** Firebase Storage
- **Auth:** Firebase Authentication

## 📁 File Structure

```
backend/
├── firebase_config.php          ✅ Updated with your credentials
├── serviceAccountKey.json       ✅ Copied from Downloads
├── firebase_auth.php           ✅ Ready to use
├── firebase_users.php          ✅ Ready to use
├── firebase_posts.php          ✅ Ready to use
├── firebase_dashboard.php      ✅ Ready to use
├── firebase_notifications.php  ✅ Ready to use
├── firebase_settings.php       ✅ Ready to use
├── firebase_analytics.php      ✅ Ready to use
├── composer.json               ✅ Dependencies defined
├── .htaccess                   ✅ Security configured
└── vendor/                     ⏳ Install with composer
```

## 🎯 API Endpoints Ready

### Authentication
- `POST /backend/firebase_auth.php?action=login`
- `POST /backend/firebase_auth.php?action=logout`
- `POST /backend/firebase_auth.php?action=create_admin`

### User Management
- `GET /backend/firebase_users.php`
- `POST /backend/firebase_users.php`
- `PUT /backend/firebase_users.php?id={userId}`
- `DELETE /backend/firebase_users.php?id={userId}`

### Post Management
- `GET /backend/firebase_posts.php`
- `POST /backend/firebase_posts.php`
- `PUT /backend/firebase_posts.php?id={postId}`
- `DELETE /backend/firebase_posts.php?id={postId}`

### Dashboard & Analytics
- `GET /backend/firebase_dashboard.php`
- `GET /backend/firebase_analytics.php?action=overview`
- `GET /backend/firebase_analytics.php?action=users`
- `GET /backend/firebase_analytics.php?action=posts`

### Notifications
- `GET /backend/firebase_notifications.php`
- `POST /backend/firebase_notifications.php`

### Settings
- `GET /backend/firebase_settings.php`
- `PUT /backend/firebase_settings.php`

## 🔥 Firebase Collections Structure

### Users Collection
```javascript
users/{userId} = {
  email: "user@example.com",
  username: "username",
  full_name: "Full Name",
  profile_picture: "https://...",
  bio: "User bio",
  is_verified: false,
  is_blocked: false,
  followers_count: 0,
  following_count: 0,
  posts_count: 0,
  device_id: "device123",
  fcm_token: "fcm_token_here",
  last_active: "2024-01-01 12:00:00",
  created_at: "2024-01-01 12:00:00",
  updated_at: "2024-01-01 12:00:00"
}
```

### Posts Collection
```javascript
posts/{postId} = {
  user_id: "user123",
  content: "Post content",
  media_urls: ["https://..."],
  media_type: "image",
  location: "Location",
  hashtags: ["#hashtag"],
  mentions: ["@user"],
  likes_count: 0,
  comments_count: 0,
  shares_count: 0,
  views_count: 0,
  is_reported: false,
  is_deleted: false,
  report_reason: "",
  created_at: "2024-01-01 12:00:00",
  updated_at: "2024-01-01 12:00:00"
}
```

## 🛡️ Security Features

- ✅ Firebase Authentication with admin claims
- ✅ Service account key secured
- ✅ CORS protection enabled
- ✅ Input validation implemented
- ✅ Error handling without exposing sensitive data

## 📱 Mobile App Integration

आपका mobile app अब इन features का use कर सकता है:

- Real-time user data sync
- Push notifications
- File uploads to Firebase Storage
- User authentication
- Real-time posts feed
- Offline data support

## 🚨 Important Notes

1. **Service Account Key:** `serviceAccountKey.json` file is secure and should not be shared
2. **Admin Credentials:** Change default admin password
3. **Firebase Rules:** Update Firestore security rules for production
4. **OneSignal:** Configure OneSignal for push notifications
5. **HTTPS:** Use HTTPS in production

## 🎉 You're Almost Ready!

सिर्फ composer install करना है और आपका admin panel ready हो जाएगा!

### Quick Test Commands:

```bash
# Test Firebase connection
php test_firebase.php

# Create admin user
curl -X POST http://localhost/backend/firebase_auth.php?action=create_admin -H "Content-Type: application/json" -d "{\"email\":\"admin@postry.com\",\"password\":\"admin123\"}"

# Login
curl -X POST http://localhost/backend/firebase_auth.php?action=login -H "Content-Type: application/json" -d "{\"email\":\"admin@postry.com\",\"password\":\"admin123\"}"
```

---

**🎯 Your Postry Social Media Admin Panel is 95% ready!**

Just install composer dependencies and you're good to go! 🚀
