<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/token.php';

header('Content-Type: application/json');
$admin = require_auth();

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    // Get ad settings
    $stmt = $pdo->query('SELECT * FROM ads_settings LIMIT 1');
    $adSettings = $stmt->fetch();
    // Get ad controls
    $stmt2 = $pdo->query('SELECT * FROM ad_controls');
    $adControls = $stmt2->fetchAll();
    echo json_encode([
        'ad_settings' => $adSettings,
        'ad_controls' => $adControls
    ]);
    exit;
}

if ($method === 'PUT') {
    parse_str(file_get_contents('php://input'), $data);
    // Update ad settings
    $fields = [];
    $params = [];
    $allowed = ['app_id','interstitial_ad_unit','native_ad_unit','banner_ad_unit','reward_ad_unit','appopen_ad_unit','ad_index','ad_app_size','gamezop_timer','gamezop_card_status'];
    foreach ($allowed as $key) {
        if (isset($data[$key])) {
            $fields[] = "$key = ?";
            $params[] = $data[$key];
        }
    }
    if (!empty($fields)) {
        $sql = 'UPDATE ads_settings SET ' . implode(', ', $fields) . ' WHERE id = 1';
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
    }
    // Update ad controls (if present)
    if (isset($data['ad_controls']) && is_array($data['ad_controls'])) {
        foreach ($data['ad_controls'] as $control) {
            if (isset($control['id'])) {
                $fields = [];
                $params = [];
                foreach (['interstitial_ad','banner_ad','native_ad','reward_ad','appopen_ad'] as $col) {
                    if (isset($control[$col])) {
                        $fields[] = "$col = ?";
                        $params[] = $control[$col];
                    }
                }
                if (!empty($fields)) {
                    $params[] = $control['id'];
                    $sql = 'UPDATE ad_controls SET ' . implode(', ', $fields) . ' WHERE id = ?';
                    $stmt = $pdo->prepare($sql);
                    $stmt->execute($params);
                }
            }
        }
    }
    echo json_encode(['success' => true]);
    exit;
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']); 