<?php
require_once __DIR__ . '/db.php';

header('Content-Type: application/json');

function generateToken($length = ADMIN_TOKEN_LENGTH) {
    return bin2hex(random_bytes($length));
}

function getAdminByUsername($username) {
    global $pdo;
    $stmt = $pdo->prepare('SELECT * FROM admin_users WHERE username = ? LIMIT 1');
    $stmt->execute([$username]);
    return $stmt->fetch();
}

function setAdminToken($admin_id, $token) {
    global $pdo;
    $stmt = $pdo->prepare('UPDATE admin_users SET remember_token = ? WHERE id = ?');
    $stmt->execute([$token, $admin_id]);
}

function clearAdminToken($admin_id) {
    global $pdo;
    $stmt = $pdo->prepare('UPDATE admin_users SET remember_token = NULL WHERE id = ?');
    $stmt->execute([$admin_id]);
}

function getAdminByToken($token) {
    global $pdo;
    $stmt = $pdo->prepare('SELECT * FROM admin_users WHERE remember_token = ? LIMIT 1');
    $stmt->execute([$token]);
    return $stmt->fetch();
}

$method = $_SERVER['REQUEST_METHOD'];
$path = $_GET['action'] ?? '';

if ($method === 'POST' && $path === 'login') {
    $data = json_decode(file_get_contents('php://input'), true);
    $username = $data['username'] ?? '';
    $password = $data['password'] ?? '';
    $admin = getAdminByUsername($username);
    if ($admin && password_verify($password, $admin['password'])) {
        $token = generateToken();
        setAdminToken($admin['id'], $token);
        echo json_encode(['remember_token' => $token]);
    } else {
        http_response_code(401);
        echo json_encode(['error' => 'Invalid credentials']);
    }
    exit;
}

if ($method === 'POST' && $path === 'logout') {
    $headers = getallheaders();
    $token = $headers['Authorization'] ?? '';
    $admin = getAdminByToken($token);
    if ($admin) {
        clearAdminToken($admin['id']);
        echo json_encode(['success' => true]);
    } else {
        http_response_code(401);
        echo json_encode(['error' => 'Invalid token']);
    }
    exit;
}

// Token and session validation for other endpoints
function require_auth() {
    // Support PHP session-based admin login
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    if (!empty($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
        // Optionally, fetch admin info if needed
        return [
            'username' => $_SESSION['admin_username'] ?? null,
            'session' => true
        ];
    }
    // Fallback to token-based auth
    $headers = function_exists('getallheaders') ? getallheaders() : [];
    $token = $headers['Authorization'] ?? '';
    $admin = getAdminByToken($token);
    if (!$admin) {
        http_response_code(401);
        echo json_encode(['error' => 'Unauthorized']);
        exit;
    }
    return $admin;
} 