<?php
// Final Cleanup Check for Postry Social Media Admin Panel
echo "🧹 Final Cleanup Check - Postry Social Media Admin Panel\n";
echo "=======================================================\n\n";

$required_files = [
    // Core Firebase Files
    'firebase_production.php' => 'Production Firebase Configuration',
    'firebase_auth.php' => 'Firebase Authentication',
    'firebase_users.php' => 'User Management',
    'firebase_posts.php' => 'Post Management',
    'firebase_dashboard.php' => 'Dashboard Analytics',
    'firebase_notifications.php' => 'Push Notifications',
    'firebase_settings.php' => 'App Settings',
    'firebase_analytics.php' => 'Advanced Analytics',
    
    // Configuration Files
    'serviceAccountKey.json' => 'Firebase Service Account',
    'composer.json' => 'Composer Configuration',
    'env.example' => 'Environment Template',
    
    // Documentation
    'QUICK_SETUP_GUIDE.md' => 'Quick Setup Guide',
    'FIREBASE_SETUP_GUIDE.md' => 'Firebase Setup Guide',
    'FIREBASE_MIGRATION_SUMMARY.md' => 'Migration Summary',
    'README.md' => 'Project Documentation',
    
    // Utility Files
    'install.php' => 'Installation Checker',
    'test_production.php' => 'Production Tester'
];

$optional_files = [
    'firebase_config.php' => 'Original Firebase Config (fallback)',
    'firebase_simple_config.php' => 'Simplified Firebase Config (fallback)',
    'test_firebase.php' => 'Firebase Connection Tester',
    'check_files.php' => 'File Checker'
];

$required_dirs = [
    'uploads' => 'File Upload Directory',
    'logs' => 'Log Files Directory'
];

$errors = [];
$warnings = [];
$success = [];

echo "📁 Checking Required Files:\n";
echo "===========================\n\n";

foreach ($required_files as $file => $description) {
    $filePath = __DIR__ . '/' . $file;
    
    if (file_exists($filePath)) {
        $size = filesize($filePath);
        $sizeFormatted = $size > 1024 ? round($size / 1024, 2) . ' KB' : $size . ' bytes';
        $success[] = "✅ $file ($description) - $sizeFormatted";
    } else {
        $errors[] = "❌ $file ($description) - Missing";
    }
}

echo "📂 Checking Optional Files:\n";
echo "===========================\n\n";

foreach ($optional_files as $file => $description) {
    $filePath = __DIR__ . '/' . $file;
    
    if (file_exists($filePath)) {
        $size = filesize($filePath);
        $sizeFormatted = $size > 1024 ? round($size / 1024, 2) . ' KB' : $size . ' bytes';
        $success[] = "✅ $file ($description) - $sizeFormatted";
    } else {
        $warnings[] = "⚠️  $file ($description) - Optional file missing";
    }
}

echo "📂 Checking Required Directories:\n";
echo "=================================\n\n";

foreach ($required_dirs as $dir => $description) {
    $dirPath = __DIR__ . '/' . $dir;
    
    if (is_dir($dirPath)) {
        if (is_writable($dirPath)) {
            $success[] = "✅ $dir/ ($description) - Exists and writable";
        } else {
            $warnings[] = "⚠️  $dir/ ($description) - Exists but not writable";
        }
    } else {
        $errors[] = "❌ $dir/ ($description) - Missing";
    }
}

// Check for any leftover old files
echo "🔍 Checking for Old/Unused Files:\n";
echo "=================================\n\n";

$old_files = [
    'ads.php', 'auth.php', 'config.php', 'dashboard.php', 'db.php',
    'promo_codes.php', 'redeem_categories.php', 'redeem_history.php',
    'redeem_request.php', 'redeem_subcategories.php', 'rewards.php',
    'send_notification.php', 'settings.php', 'tasks.php', 'token.php',
    'users.php', 'error_log'
];

$found_old_files = [];
foreach ($old_files as $old_file) {
    if (file_exists(__DIR__ . '/' . $old_file)) {
        $found_old_files[] = $old_file;
    }
}

if (empty($found_old_files)) {
    $success[] = "✅ No old/unused files found - Cleanup complete";
} else {
    $warnings[] = "⚠️  Found old files that should be deleted: " . implode(', ', $found_old_files);
}

// Display results
echo "📊 Final Cleanup Results:\n";
echo "========================\n\n";

if (!empty($success)) {
    echo "✅ SUCCESS (" . count($success) . " items):\n";
    foreach ($success as $msg) {
        echo "   $msg\n";
    }
    echo "\n";
}

if (!empty($warnings)) {
    echo "⚠️  WARNINGS (" . count($warnings) . " items):\n";
    foreach ($warnings as $msg) {
        echo "   $msg\n";
    }
    echo "\n";
}

if (!empty($errors)) {
    echo "❌ ERRORS (" . count($errors) . " items):\n";
    foreach ($errors as $msg) {
        echo "   $msg\n";
    }
    echo "\n";
}

// Final status
$totalChecks = count($success) + count($warnings) + count($errors);
$successRate = $totalChecks > 0 ? round((count($success) / $totalChecks) * 100, 1) : 0;

echo "🎯 FINAL SUMMARY:\n";
echo "=================\n";
echo "Total Checks: $totalChecks\n";
echo "Success Rate: $successRate%\n";
echo "Success: " . count($success) . "\n";
echo "Warnings: " . count($warnings) . "\n";
echo "Errors: " . count($errors) . "\n\n";

if (empty($errors)) {
    echo "🎉 CLEANUP STATUS: PERFECT!\n";
    echo "===========================\n\n";
    echo "🚀 Your admin panel is clean and optimized!\n";
    echo "📱 All unnecessary files have been removed.\n";
    echo "🔥 Only essential Firebase files remain.\n\n";
    
    echo "📋 Final File Count:\n";
    echo "• Core Firebase Files: 8\n";
    echo "• Configuration Files: 3\n";
    echo "• Documentation Files: 4\n";
    echo "• Utility Files: 2\n";
    echo "• Optional Files: 4\n";
    echo "• Total: ~21 essential files\n\n";
    
} else {
    echo "❌ CLEANUP STATUS: NEEDS ATTENTION\n";
    echo "==================================\n\n";
    echo "Please fix the errors above.\n\n";
}

echo "🎯 Project: Postry Social Media Admin Panel\n";
echo "🔥 Backend: Firebase Firestore (Production Ready)\n";
echo "📱 Status: Clean, Optimized, and Ready for Use\n\n";

echo "🚀 Your admin panel is now perfectly clean and ready!\n";
?>
