<?php
// Use production Firebase configuration
require_once __DIR__ . '/firebase_production.php';

header('Content-Type: application/json');
require_firebase_auth();

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    // Get app settings
    $settings = FirebaseHelper::getDocument('app_settings', 'main');
    
    if (!$settings) {
        // Create default settings if they don't exist
        $defaultSettings = [
            'app_name' => 'Social Media App',
            'app_version' => '1.0.0',
            'maintenance_mode' => false,
            'registration_enabled' => true,
            'post_creation_enabled' => true,
            'max_post_length' => 1000,
            'max_media_per_post' => 10,
            'max_file_size_mb' => 50,
            'allowed_media_types' => ['image/jpeg', 'image/png', 'image/gif', 'video/mp4', 'audio/mp3'],
            'enable_notifications' => true,
            'enable_push_notifications' => true,
            'enable_email_notifications' => false,
            'admin_email' => 'admin@yourdomain.com',
            'support_email' => 'support@yourdomain.com',
            'privacy_policy_url' => 'https://yourdomain.com/privacy',
            'terms_of_service_url' => 'https://yourdomain.com/terms',
            'about_us_url' => 'https://yourdomain.com/about',
            'contact_us_url' => 'https://yourdomain.com/contact',
            'facebook_url' => '',
            'twitter_url' => '',
            'instagram_url' => '',
            'youtube_url' => '',
            'linkedin_url' => '',
            'app_store_url' => '',
            'play_store_url' => '',
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        ];
        
        $settingsId = FirebaseHelper::addDocument('app_settings', $defaultSettings);
        if ($settingsId) {
            $defaultSettings['id'] = $settingsId;
            $settings = $defaultSettings;
        }
    }
    
    echo json_encode(['success' => true, 'data' => $settings]);
    exit;
}

if ($method === 'PUT') {
    $data = json_decode(file_get_contents('php://input'), true);
    
    $updateData = [];
    $allowedFields = [
        'app_name', 'app_version', 'maintenance_mode', 'registration_enabled',
        'post_creation_enabled', 'max_post_length', 'max_media_per_post',
        'max_file_size_mb', 'allowed_media_types', 'enable_notifications',
        'enable_push_notifications', 'enable_email_notifications', 'admin_email',
        'support_email', 'privacy_policy_url', 'terms_of_service_url',
        'about_us_url', 'contact_us_url', 'facebook_url', 'twitter_url',
        'instagram_url', 'youtube_url', 'linkedin_url', 'app_store_url',
        'play_store_url'
    ];
    
    foreach ($allowedFields as $field) {
        if (isset($data[$field])) {
            $updateData[$field] = $data[$field];
        }
    }
    
    if (empty($updateData)) {
        http_response_code(400);
        echo json_encode(['error' => 'No fields to update']);
        exit;
    }
    
    // Check if settings document exists
    $existingSettings = FirebaseHelper::getDocument('app_settings', 'main');
    
    if ($existingSettings) {
        $success = FirebaseHelper::updateDocument('app_settings', 'main', $updateData);
    } else {
        $updateData['created_at'] = date('Y-m-d H:i:s');
        $updateData['updated_at'] = date('Y-m-d H:i:s');
        $success = FirebaseHelper::addDocument('app_settings', $updateData);
    }
    
    if ($success) {
        echo json_encode(['success' => true, 'message' => 'Settings updated successfully']);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to update settings']);
    }
    exit;
}

if ($method === 'POST' && isset($_GET['action'])) {
    $action = $_GET['action'];
    
    switch ($action) {
        case 'reset_to_defaults':
            $defaultSettings = [
                'app_name' => 'Social Media App',
                'app_version' => '1.0.0',
                'maintenance_mode' => false,
                'registration_enabled' => true,
                'post_creation_enabled' => true,
                'max_post_length' => 1000,
                'max_media_per_post' => 10,
                'max_file_size_mb' => 50,
                'allowed_media_types' => ['image/jpeg', 'image/png', 'image/gif', 'video/mp4', 'audio/mp3'],
                'enable_notifications' => true,
                'enable_push_notifications' => true,
                'enable_email_notifications' => false,
                'admin_email' => 'admin@yourdomain.com',
                'support_email' => 'support@yourdomain.com',
                'privacy_policy_url' => 'https://yourdomain.com/privacy',
                'terms_of_service_url' => 'https://yourdomain.com/terms',
                'about_us_url' => 'https://yourdomain.com/about',
                'contact_us_url' => 'https://yourdomain.com/contact',
                'facebook_url' => '',
                'twitter_url' => '',
                'instagram_url' => '',
                'youtube_url' => '',
                'linkedin_url' => '',
                'app_store_url' => '',
                'play_store_url' => '',
                'updated_at' => date('Y-m-d H:i:s')
            ];
            
            $success = FirebaseHelper::updateDocument('app_settings', 'main', $defaultSettings);
            
            if ($success) {
                echo json_encode(['success' => true, 'message' => 'Settings reset to defaults successfully']);
            } else {
                http_response_code(500);
                echo json_encode(['error' => 'Failed to reset settings']);
            }
            break;
            
        case 'export_settings':
            $settings = FirebaseHelper::getDocument('app_settings', 'main');
            
            if ($settings) {
                header('Content-Type: application/json');
                header('Content-Disposition: attachment; filename="app_settings_' . date('Y-m-d') . '.json"');
                echo json_encode($settings, JSON_PRETTY_PRINT);
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'Settings not found']);
            }
            break;
            
        case 'import_settings':
            if (!isset($_FILES['settings_file'])) {
                http_response_code(400);
                echo json_encode(['error' => 'Settings file required']);
                exit;
            }
            
            $file = $_FILES['settings_file'];
            if ($file['error'] !== UPLOAD_ERR_OK) {
                http_response_code(400);
                echo json_encode(['error' => 'File upload failed']);
                exit;
            }
            
            $content = file_get_contents($file['tmp_name']);
            $settings = json_decode($content, true);
            
            if (!$settings) {
                http_response_code(400);
                echo json_encode(['error' => 'Invalid JSON file']);
                exit;
            }
            
            // Remove id and timestamps from imported data
            unset($settings['id'], $settings['created_at'], $settings['updated_at']);
            $settings['updated_at'] = date('Y-m-d H:i:s');
            
            $success = FirebaseHelper::updateDocument('app_settings', 'main', $settings);
            
            if ($success) {
                echo json_encode(['success' => true, 'message' => 'Settings imported successfully']);
            } else {
                http_response_code(500);
                echo json_encode(['error' => 'Failed to import settings']);
            }
            break;
            
        default:
            http_response_code(400);
            echo json_encode(['error' => 'Invalid action']);
            break;
    }
    exit;
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);
?>
