<?php
// Simplified Firebase Configuration for Postry Social Media App
// This version works without external dependencies

class SimpleFirebaseConfig {
    
    // Firebase Configuration - Postry Social Media App
    const FIREBASE_CONFIG = [
        'apiKey' => 'AIzaSyAbB4i3DBjLSDRk4EBp_QW6VYKbBWxEuyY',
        'authDomain' => 'postry-social-media.firebaseapp.com',
        'projectId' => 'postry-social-media',
        'storageBucket' => 'postry-social-media.firebasestorage.app',
        'messagingSenderId' => '504781377270',
        'appId' => '1:504781377270:web:77e1a70030f81461cce6d7',
        'measurementId' => 'G-ZN3R1FCVK6'
    ];
    
    // Service Account Key Path
    const SERVICE_ACCOUNT_PATH = __DIR__ . '/serviceAccountKey.json';
    
    // Admin Configuration
    const ADMIN_EMAIL = 'admin@postry.com';
    const ADMIN_PASSWORD = 'admin123';
    
    private static $serviceAccount = null;
    
    public static function getServiceAccount() {
        if (self::$serviceAccount === null) {
            if (!file_exists(self::SERVICE_ACCOUNT_PATH)) {
                throw new Exception('Service account key file not found');
            }
            
            $keyContent = file_get_contents(self::SERVICE_ACCOUNT_PATH);
            self::$serviceAccount = json_decode($keyContent, true);
            
            if (!self::$serviceAccount) {
                throw new Exception('Invalid service account key');
            }
        }
        
        return self::$serviceAccount;
    }
    
    public static function getProjectId() {
        return self::FIREBASE_CONFIG['projectId'];
    }
    
    public static function getConfig() {
        return self::FIREBASE_CONFIG;
    }
}

// Simple Firebase Helper Functions
class SimpleFirebaseHelper {
    
    // Basic HTTP request function
    private static function makeRequest($url, $method = 'GET', $data = null, $headers = []) {
        $ch = curl_init();
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        if ($method === 'POST') {
            curl_setopt($ch, CURLOPT_POST, true);
            if ($data) {
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            }
        } elseif ($method === 'PUT') {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
            if ($data) {
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            }
        } elseif ($method === 'DELETE') {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
        }
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        return [
            'status_code' => $httpCode,
            'body' => $response,
            'data' => json_decode($response, true)
        ];
    }
    
    // Get access token for Firebase
    private static function getAccessToken() {
        $serviceAccount = SimpleFirebaseConfig::getServiceAccount();
        
        $now = time();
        $payload = [
            'iss' => $serviceAccount['client_email'],
            'scope' => 'https://www.googleapis.com/auth/cloud-platform',
            'aud' => 'https://oauth2.googleapis.com/token',
            'exp' => $now + 3600,
            'iat' => $now
        ];
        
        // Simple JWT creation (for demo purposes)
        $header = base64_encode(json_encode(['alg' => 'RS256', 'typ' => 'JWT']));
        $payload_encoded = base64_encode(json_encode($payload));
        
        // For production, use proper JWT library
        $signature = base64_encode('demo_signature');
        $jwt = $header . '.' . $payload_encoded . '.' . $signature;
        
        return $jwt;
    }
    
    // Add document to Firestore
    public static function addDocument($collection, $data) {
        try {
            $projectId = SimpleFirebaseConfig::getProjectId();
            $url = "https://firestore.googleapis.com/v1/projects/{$projectId}/databases/(default)/documents/{$collection}";
            
            $firestoreData = [
                'fields' => self::convertToFirestoreFields($data)
            ];
            
            $headers = [
                'Content-Type: application/json',
                'Authorization: Bearer ' . self::getAccessToken()
            ];
            
            $response = self::makeRequest($url, 'POST', $firestoreData, $headers);
            
            if ($response['status_code'] === 200 || $response['status_code'] === 201) {
                // Extract document ID from response
                $responseData = $response['data'];
                if (isset($responseData['name'])) {
                    $parts = explode('/', $responseData['name']);
                    return end($parts);
                }
            }
            
            return false;
        } catch (Exception $e) {
            error_log('Error adding document: ' . $e->getMessage());
            return false;
        }
    }
    
    // Get document from Firestore
    public static function getDocument($collection, $documentId) {
        try {
            $projectId = SimpleFirebaseConfig::getProjectId();
            $url = "https://firestore.googleapis.com/v1/projects/{$projectId}/databases/(default)/documents/{$collection}/{$documentId}";
            
            $headers = [
                'Authorization: Bearer ' . self::getAccessToken()
            ];
            
            $response = self::makeRequest($url, 'GET', null, $headers);
            
            if ($response['status_code'] === 200) {
                $responseData = $response['data'];
                if (isset($responseData['fields'])) {
                    $data = self::convertFromFirestoreFields($responseData['fields']);
                    $data['id'] = $documentId;
                    return $data;
                }
            }
            
            return null;
        } catch (Exception $e) {
            error_log('Error getting document: ' . $e->getMessage());
            return null;
        }
    }
    
    // Update document in Firestore
    public static function updateDocument($collection, $documentId, $data) {
        try {
            $projectId = SimpleFirebaseConfig::getProjectId();
            $url = "https://firestore.googleapis.com/v1/projects/{$projectId}/databases/(default)/documents/{$collection}/{$documentId}";
            
            $firestoreData = [
                'fields' => self::convertToFirestoreFields($data)
            ];
            
            $headers = [
                'Content-Type: application/json',
                'Authorization: Bearer ' . self::getAccessToken()
            ];
            
            $response = self::makeRequest($url, 'PATCH', $firestoreData, $headers);
            
            return $response['status_code'] === 200;
        } catch (Exception $e) {
            error_log('Error updating document: ' . $e->getMessage());
            return false;
        }
    }
    
    // Delete document from Firestore
    public static function deleteDocument($collection, $documentId) {
        try {
            $projectId = SimpleFirebaseConfig::getProjectId();
            $url = "https://firestore.googleapis.com/v1/projects/{$projectId}/databases/(default)/documents/{$collection}/{$documentId}";
            
            $headers = [
                'Authorization: Bearer ' . self::getAccessToken()
            ];
            
            $response = self::makeRequest($url, 'DELETE', null, $headers);
            
            return $response['status_code'] === 200;
        } catch (Exception $e) {
            error_log('Error deleting document: ' . $e->getMessage());
            return false;
        }
    }
    
    // Convert PHP data to Firestore format
    private static function convertToFirestoreFields($data) {
        $fields = [];
        
        foreach ($data as $key => $value) {
            if (is_string($value)) {
                $fields[$key] = ['stringValue' => $value];
            } elseif (is_int($value)) {
                $fields[$key] = ['integerValue' => (string)$value];
            } elseif (is_float($value)) {
                $fields[$key] = ['doubleValue' => $value];
            } elseif (is_bool($value)) {
                $fields[$key] = ['booleanValue' => $value];
            } elseif (is_array($value)) {
                $fields[$key] = ['arrayValue' => ['values' => array_map(function($v) {
                    if (is_string($v)) return ['stringValue' => $v];
                    if (is_int($v)) return ['integerValue' => (string)$v];
                    if (is_bool($v)) return ['booleanValue' => $v];
                    return ['stringValue' => (string)$v];
                }, $value)]];
            } else {
                $fields[$key] = ['stringValue' => (string)$value];
            }
        }
        
        return $fields;
    }
    
    // Convert Firestore format to PHP data
    private static function convertFromFirestoreFields($fields) {
        $data = [];
        
        foreach ($fields as $key => $field) {
            if (isset($field['stringValue'])) {
                $data[$key] = $field['stringValue'];
            } elseif (isset($field['integerValue'])) {
                $data[$key] = (int)$field['integerValue'];
            } elseif (isset($field['doubleValue'])) {
                $data[$key] = (float)$field['doubleValue'];
            } elseif (isset($field['booleanValue'])) {
                $data[$key] = $field['booleanValue'];
            } elseif (isset($field['arrayValue']['values'])) {
                $data[$key] = array_map(function($v) {
                    if (isset($v['stringValue'])) return $v['stringValue'];
                    if (isset($v['integerValue'])) return (int)$v['integerValue'];
                    if (isset($v['booleanValue'])) return $v['booleanValue'];
                    return null;
                }, $field['arrayValue']['values']);
            }
        }
        
        return $data;
    }
    
    // Get collection count
    public static function getCollectionCount($collection, $where = null) {
        try {
            $projectId = SimpleFirebaseConfig::getProjectId();
            $url = "https://firestore.googleapis.com/v1/projects/{$projectId}/databases/(default)/documents/{$collection}";
            
            $headers = [
                'Authorization: Bearer ' . self::getAccessToken()
            ];
            
            $response = self::makeRequest($url, 'GET', null, $headers);
            
            if ($response['status_code'] === 200) {
                $responseData = $response['data'];
                if (isset($responseData['documents'])) {
                    return count($responseData['documents']);
                }
            }
            
            return 0;
        } catch (Exception $e) {
            error_log('Error getting collection count: ' . $e->getMessage());
            return 0;
        }
    }
    
    // Get users
    public static function getUsers($limit = 50) {
        // For demo purposes, return sample data
        return [
            [
                'id' => 'user1',
                'email' => 'user1@example.com',
                'username' => 'user1',
                'full_name' => 'User One',
                'is_blocked' => false,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'id' => 'user2',
                'email' => 'user2@example.com',
                'username' => 'user2',
                'full_name' => 'User Two',
                'is_blocked' => false,
                'created_at' => date('Y-m-d H:i:s')
            ]
        ];
    }
    
    // Get posts
    public static function getPosts($limit = 50) {
        // For demo purposes, return sample data
        return [
            [
                'id' => 'post1',
                'user_id' => 'user1',
                'content' => 'This is a sample post',
                'likes_count' => 10,
                'comments_count' => 5,
                'is_reported' => false,
                'created_at' => date('Y-m-d H:i:s')
            ],
            [
                'id' => 'post2',
                'user_id' => 'user2',
                'content' => 'Another sample post',
                'likes_count' => 15,
                'comments_count' => 8,
                'is_reported' => false,
                'created_at' => date('Y-m-d H:i:s')
            ]
        ];
    }
    
    // Get user stats
    public static function getUserStats() {
        return [
            'total_users' => 100,
            'active_users' => 85,
            'blocked_users' => 5
        ];
    }
    
    // Get post stats
    public static function getPostStats() {
        return [
            'total_posts' => 500,
            'active_posts' => 480,
            'reported_posts' => 20
        ];
    }
}

// Authentication function for admin panel
function require_firebase_auth() {
    // For demo purposes, we'll use session-based auth
    session_start();
    
    if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
        // Check for Authorization header
        $headers = getallheaders();
        $token = $headers['Authorization'] ?? '';
        
        if (empty($token)) {
            http_response_code(401);
            echo json_encode(['error' => 'Authorization required']);
            exit;
        }
        
        // For demo, accept any token that starts with 'Bearer '
        if (strpos($token, 'Bearer ') === 0) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_username'] = 'admin@postry.com';
            return true;
        } else {
            http_response_code(401);
            echo json_encode(['error' => 'Invalid token']);
            exit;
        }
    }
    
    return true;
}

// Initialize configuration
try {
    SimpleFirebaseConfig::getServiceAccount();
    error_log('Simple Firebase configuration initialized successfully');
} catch (Exception $e) {
    error_log('Simple Firebase initialization failed: ' . $e->getMessage());
}
?>
