<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/token.php';

header('Content-Type: application/json');
$admin = require_auth();
$method = $_SERVER['REQUEST_METHOD'];
$upload_dir = __DIR__ . '/../uploads/redeem_categories/';
$base_url = dirname($_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']) . '/../uploads/redeem_categories/';
if (!file_exists($upload_dir)) mkdir($upload_dir, 0777, true);

if ($method === 'GET') {
    $stmt = $pdo->query('SELECT * FROM redeem_options_categories ORDER BY id DESC');
    echo json_encode(['data' => $stmt->fetchAll()]);
    exit;
}

if ($method === 'POST') {
    $name = $_POST['category_name'] ?? '';
    $image_url = $_POST['category_image_url'] ?? '';
    if (isset($_FILES['category_image_file']) && $_FILES['category_image_file']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['category_image_file']['name'], PATHINFO_EXTENSION);
        $fname = uniqid('cat_', true) . '.' . $ext;
        $target = $upload_dir . $fname;
        if (move_uploaded_file($_FILES['category_image_file']['tmp_name'], $target)) {
            $image_url = '/uploads/redeem_categories/' . $fname;
        }
    }
    if (!$name || !$image_url) {
        http_response_code(400);
        echo json_encode(['error' => 'Name and image required']);
        exit;
    }
    $stmt = $pdo->prepare('INSERT INTO redeem_options_categories (category_name, category_image_url) VALUES (?, ?)');
    $stmt->execute([$name, $image_url]);
    echo json_encode(['success' => true, 'id' => $pdo->lastInsertId()]);
    exit;
}

if ($method === 'POST' && isset($_POST['_method']) && $_POST['_method'] === 'PUT') {
    // For AJAX PUT via POST+_method
    $id = $_POST['id'] ?? null;
    $name = $_POST['category_name'] ?? '';
    $image_url = $_POST['category_image_url'] ?? '';
    if (isset($_FILES['category_image_file']) && $_FILES['category_image_file']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['category_image_file']['name'], PATHINFO_EXTENSION);
        $fname = uniqid('cat_', true) . '.' . $ext;
        $target = $upload_dir . $fname;
        if (move_uploaded_file($_FILES['category_image_file']['tmp_name'], $target)) {
            $image_url = '/uploads/redeem_categories/' . $fname;
        }
    }
    if (!$id || !$name || !$image_url) {
        http_response_code(400);
        echo json_encode(['error' => 'ID, name, and image required']);
        exit;
    }
    $stmt = $pdo->prepare('UPDATE redeem_options_categories SET category_name=?, category_image_url=? WHERE id=?');
    $stmt->execute([$name, $image_url, $id]);
    echo json_encode(['success' => true]);
    exit;
}

if ($method === 'DELETE') {
    $id = $_GET['id'] ?? null;
    if (!$id) {
        http_response_code(400);
        echo json_encode(['error' => 'Missing category id']);
        exit;
    }
    // Optionally delete image file
    $stmt = $pdo->prepare('SELECT category_image_url FROM redeem_options_categories WHERE id=?');
    $stmt->execute([$id]);
    $row = $stmt->fetch();
    if ($row && strpos($row['category_image_url'], '/uploads/redeem_categories/') === 0) {
        $img_path = __DIR__ . '/../' . ltrim($row['category_image_url'], '/');
        if (file_exists($img_path)) @unlink($img_path);
    }
    $stmt = $pdo->prepare('DELETE FROM redeem_options_categories WHERE id=?');
    $stmt->execute([$id]);
    echo json_encode(['success' => true]);
    exit;
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']); 