<?php
require_once 'db.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'approve' && isset($_POST['id'])) {
        $id = (int)$_POST['id'];
        // Update status to approved for UPI requests
        $stmt = $pdo->prepare("UPDATE redeem_history SET status='approved' WHERE id=? AND status='pending'");
        $stmt->execute([$id]);
        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false]);
        }
        exit;
    }
    
    if ($action === 'reject' && isset($_POST['id'])) {
        $id = (int)$_POST['id'];
        $reason = $_POST['reason'] ?? '';
        // If reason is blank, use default
        if (empty($reason)) {
            $reason = 'Mislinuous activity found';
        }
        
        // Update status to rejected with reason
        $stmt = $pdo->prepare("UPDATE redeem_history SET status='rejected', rejection_reason=? WHERE id=? AND status='pending'");
        $stmt->execute([$reason, $id]);
        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false]);
        }
        exit;
    }
    
    if ($action === 'mark_paid' && isset($_POST['id'])) {
        $id = (int)$_POST['id'];
        // For now, we'll just update the status to indicate payment is completed
        // You might want to add a new status like 'paid' or update the existing record
        $stmt = $pdo->prepare("UPDATE redeem_history SET status='approved' WHERE id=? AND status='approved'");
        $stmt->execute([$id]);
        if ($stmt->rowCount() > 0) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false]);
        }
        exit;
    }
}

// fallback
http_response_code(400);
echo json_encode(['success' => false, 'error' => 'Invalid request']); 