<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/token.php';

header('Content-Type: application/json');
$admin = require_auth();
$method = $_SERVER['REQUEST_METHOD'];
$upload_dir = __DIR__ . '/../uploads/redeem_subcategories/';
if (!file_exists($upload_dir)) mkdir($upload_dir, 0777, true);

if ($method === 'GET') {
    $stmt = $pdo->query('SELECT s.*, c.category_name FROM redeem_options_subcategories s LEFT JOIN redeem_options_categories c ON s.category_id = c.id ORDER BY s.id DESC');
    echo json_encode(['data' => $stmt->fetchAll()]);
    exit;
}

if ($method === 'POST') {
    $name = $_POST['sub_category_name'] ?? '';
    $category_id = $_POST['category_id'] ?? '';
    $coins = $_POST['coins'] ?? 0;
    $cash = $_POST['cash'] ?? 0;
    $is_enabled = isset($_POST['is_enabled']) ? 1 : 0;
    $image_url = $_POST['sub_category_image_url'] ?? '';
    if (isset($_FILES['sub_category_image_file']) && $_FILES['sub_category_image_file']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['sub_category_image_file']['name'], PATHINFO_EXTENSION);
        $fname = uniqid('subcat_', true) . '.' . $ext;
        $target = $upload_dir . $fname;
        if (move_uploaded_file($_FILES['sub_category_image_file']['tmp_name'], $target)) {
            $image_url = '/uploads/redeem_subcategories/' . $fname;
        }
    }
    if (!$name || !$category_id || !$image_url) {
        http_response_code(400);
        echo json_encode(['error' => 'Name, category, and image required']);
        exit;
    }
    $stmt = $pdo->prepare('INSERT INTO redeem_options_subcategories (category_id, sub_category_name, sub_category_image_url, coins, cash, is_enabled) VALUES (?, ?, ?, ?, ?, ?)');
    $stmt->execute([$category_id, $name, $image_url, $coins, $cash, $is_enabled]);
    echo json_encode(['success' => true, 'id' => $pdo->lastInsertId()]);
    exit;
}

if ($method === 'POST' && isset($_POST['_method']) && $_POST['_method'] === 'PUT') {
    $id = $_POST['id'] ?? null;
    $name = $_POST['sub_category_name'] ?? '';
    $category_id = $_POST['category_id'] ?? '';
    $coins = $_POST['coins'] ?? 0;
    $cash = $_POST['cash'] ?? 0;
    $is_enabled = isset($_POST['is_enabled']) ? 1 : 0;
    $image_url = $_POST['sub_category_image_url'] ?? '';
    if (isset($_FILES['sub_category_image_file']) && $_FILES['sub_category_image_file']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['sub_category_image_file']['name'], PATHINFO_EXTENSION);
        $fname = uniqid('subcat_', true) . '.' . $ext;
        $target = $upload_dir . $fname;
        if (move_uploaded_file($_FILES['sub_category_image_file']['tmp_name'], $target)) {
            $image_url = '/uploads/redeem_subcategories/' . $fname;
        }
    }
    if (!$id || !$name || !$category_id || !$image_url) {
        http_response_code(400);
        echo json_encode(['error' => 'ID, name, category, and image required']);
        exit;
    }
    $stmt = $pdo->prepare('UPDATE redeem_options_subcategories SET category_id=?, sub_category_name=?, sub_category_image_url=?, coins=?, cash=?, is_enabled=? WHERE id=?');
    $stmt->execute([$category_id, $name, $image_url, $coins, $cash, $is_enabled, $id]);
    echo json_encode(['success' => true]);
    exit;
}

if ($method === 'DELETE') {
    $id = $_GET['id'] ?? null;
    if (!$id) {
        http_response_code(400);
        echo json_encode(['error' => 'Missing sub-category id']);
        exit;
    }
    $stmt = $pdo->prepare('SELECT sub_category_image_url FROM redeem_options_subcategories WHERE id=?');
    $stmt->execute([$id]);
    $row = $stmt->fetch();
    if ($row && strpos($row['sub_category_image_url'], '/uploads/redeem_subcategories/') === 0) {
        $img_path = __DIR__ . '/../' . ltrim($row['sub_category_image_url'], '/');
        if (file_exists($img_path)) @unlink($img_path);
    }
    $stmt = $pdo->prepare('DELETE FROM redeem_options_subcategories WHERE id=?');
    $stmt->execute([$id]);
    echo json_encode(['success' => true]);
    exit;
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']); 