<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/token.php';

header('Content-Type: application/json');
$admin = require_auth();
$method = $_SERVER['REQUEST_METHOD'];
$upload_dir = __DIR__ . '/../uploads/giftcodes/'; // Optional directory for future image uploads if needed
if (!file_exists($upload_dir)) mkdir($upload_dir, 0777, true);

if ($method === 'GET') {
    $stmt = $pdo->query('SELECT g.*, s.sub_category_name, c.category_name FROM giftcodes g LEFT JOIN redeem_options_subcategories s ON g.category_id = s.id LEFT JOIN redeem_options_categories c ON s.category_id = c.id ORDER BY g.id DESC');
    echo json_encode(['success' => true, 'data' => $stmt->fetchAll()]);
    exit;
}

if ($method === 'POST') {
    $action = $_POST['action'] ?? '';
    $id = $_POST['id'] ?? null;
    $category_id = $_POST['sub_category_id'] ?? ''; // Using sub_category_id as per frontend
    $coins = $_POST['coins'] ?? 0;
    $code = $_POST['code'] ?? '';
    $pin = $_POST['pin'] ?? '';
    $is_used = isset($_POST['is_used']) ? 1 : 0;
    $assigned_to = $_POST['assigned_to'] ?? null;

    if (!$category_id || !$code) {
        http_response_code(400);
        echo json_encode(['success' => false, 'error' => 'Category ID and code are required']);
        exit;
    }

    if ($action === 'add_reward') {
        $stmt = $pdo->prepare('INSERT INTO giftcodes (category_id, coins, code, pin, is_used, assigned_to, assigned_at) VALUES (?, ?, ?, ?, ?, ?, NOW())');
        $stmt->execute([$category_id, $coins, $code, $pin, $is_used, $assigned_to]);
        echo json_encode(['success' => true, 'id' => $pdo->lastInsertId()]);
    } elseif ($action === 'edit_reward' && $id) {
        $stmt = $pdo->prepare('UPDATE giftcodes SET category_id=?, coins=?, code=?, pin=?, is_used=?, assigned_to=?, assigned_at=NOW() WHERE id=?');
        $stmt->execute([$category_id, $coins, $code, $pin, $is_used, $assigned_to, $id]);
        echo json_encode(['success' => true]);
    } else {
        http_response_code(400);
        echo json_encode(['success' => false, 'error' => 'Invalid action or missing ID for edit']);
    }
    exit;
}

if ($method === 'DELETE') {
    $id = $_GET['id'] ?? null;
    if (!$id) {
        http_response_code(400);
        echo json_encode(['success' => false, 'error' => 'Missing gift code ID']);
        exit;
    }
    $stmt = $pdo->prepare('DELETE FROM giftcodes WHERE id=?');
    $stmt->execute([$id]);
    echo json_encode(['success' => true]);
    exit;
}

http_response_code(405);
echo json_encode(['success' => false, 'error' => 'Method not allowed']);
?>