<?php
header('Content-Type: application/json');
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    echo json_encode(['success'=>false,'message'=>'Unauthorized']);
    exit;
}

require_once 'db.php';

// OneSignal credentials (replace with your real keys)
define('ONESIGNAL_APP_ID', '4715b283-44bf-45ff-bbe1-74c1366ad9da');
define('ONESIGNAL_API_KEY', 'os_v2_app_i4k3fa2ex5c77o7botatm2wz3jzlsuxzskwekz5c2oj5e5xcioy2njzfdqb4rixqotmbwc2he6vyapm4oq5jcnk5s7joyexudamu5ny');

function send_onesignal_notification($title, $message, $image_url = null, $action_url = null, $platform = 'all', $schedule = null, $buttons = []) {
    $content = ["en" => $message];
    $headings = ["en" => $title];
    $fields = [
        'app_id' => ONESIGNAL_APP_ID,
        'headings' => $headings,
        'contents' => $content,
        'included_segments' => ['All']
    ];
    // Platform filter
    if ($platform && $platform !== 'all') {
        unset($fields['included_segments']);
        $fields['filters'] = [
            ["field" => "device_type", "relation" => "=", "value" => (
                $platform === 'android' ? 1 : ($platform === 'ios' ? 0 : 5)
            )]
        ];
    }
    // Image
    if ($image_url) {
        $fields['big_picture'] = $image_url;
        $fields['ios_attachments'] = ["id1" => $image_url];
        $fields['chrome_web_image'] = $image_url;
    }
    // Action URL
    if ($action_url) {
        $fields['url'] = $action_url;
    }
    // Schedule
    if ($schedule) {
        $fields['send_after'] = date('c', strtotime($schedule));
    }
    // Buttons
    if (!empty($buttons)) {
        $fields['buttons'] = $buttons;
    }
    $fields = json_encode($fields);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://onesignal.com/api/v1/notifications');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic ' . ONESIGNAL_API_KEY
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    $result = curl_exec($ch);
    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    $res = json_decode($result, true);
    if ($httpcode === 200 && isset($res['id'])) {
        return ['success'=>true, 'message'=>'Notification sent!', 'onesignal_id'=>$res['id'], 'user_count'=>$res['recipients'] ?? 0];
    } else {
        return ['success'=>false, 'message'=>'Failed to send: '.($res['errors'][0]??'Unknown error')];
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title'] ?? '');
    $message = trim($_POST['message'] ?? '');
    $image_url = trim($_POST['image_url'] ?? '');
    $action_url = trim($_POST['action_url'] ?? '');
    $platform = $_POST['platform'] ?? 'all';
    $schedule = $_POST['schedule'] ?? null;
    
    // Buttons
    $buttons = [];
    $button1_text = $_POST['button1_text'] ?? '';
    $button1_url = $_POST['button1_url'] ?? '';
    $button2_text = $_POST['button2_text'] ?? '';
    $button2_url = $_POST['button2_url'] ?? '';
    
    if (!empty($button1_text) && !empty($button1_url)) {
        $buttons[] = [
            'id' => 'btn1',
            'text' => $button1_text,
            'url' => $button1_url
        ];
    }
    if (!empty($button2_text) && !empty($button2_url)) {
        $buttons[] = [
            'id' => 'btn2',
            'text' => $button2_text,
            'url' => $button2_url
        ];
    }
    
    if (!$title || !$message) {
        echo json_encode(['success'=>false,'message'=>'Title and message required']);
        exit;
    }

    // Store notification in database first
    $stmt = $pdo->prepare("
        INSERT INTO notifications (
            title, message, image_url, action_url, platform, 
            schedule_time, status, button1_text, button1_url, 
            button2_text, button2_url, created_at
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())
    ");
    
    $status = $schedule ? 'scheduled' : 'pending';
    $schedule_time = $schedule ? date('Y-m-d H:i:s', strtotime($schedule)) : null;
    
    $stmt->execute([
        $title, $message, $image_url, $action_url, $platform,
        $schedule_time, $status, $button1_text, $button1_url,
        $button2_text, $button2_url
    ]);
    
    $notification_id = $pdo->lastInsertId();
    
    // If scheduled, just store and return
    if ($schedule) {
        echo json_encode(['success'=>true, 'message'=>'Notification scheduled for ' . date('d-m-Y H:i', strtotime($schedule))]);
        exit;
    }
    
    // Send notification immediately
    $result = send_onesignal_notification($title, $message, $image_url, $action_url, $platform, null, $buttons);
    
    if ($result['success']) {
        // Update notification with sent details
        $stmt = $pdo->prepare("
            UPDATE notifications 
            SET status = 'sent', sent_time = NOW(), user_count = ?, onesignal_id = ?
            WHERE id = ?
        ");
        $stmt->execute([$result['user_count'], $result['onesignal_id'], $notification_id]);
        
        echo json_encode(['success'=>true, 'message'=>'Notification sent to ' . $result['user_count'] . ' users!']);
    } else {
        // Update notification with failed status
        $stmt = $pdo->prepare("UPDATE notifications SET status = 'failed' WHERE id = ?");
        $stmt->execute([$notification_id]);
        
        echo json_encode($result);
    }
    exit;
}

// Handle scheduled notifications (cron job endpoint)
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['cron'])) {
    $stmt = $pdo->prepare("
        SELECT id, title, message, image_url, action_url, platform,
               button1_text, button1_url, button2_text, button2_url
        FROM notifications 
        WHERE status = 'scheduled' 
        AND schedule_time <= NOW()
    ");
    $stmt->execute();
    $scheduled_notifications = $stmt->fetchAll();
    
    $results = [];
    foreach ($scheduled_notifications as $notification) {
        $buttons = [];
        if (!empty($notification['button1_text']) && !empty($notification['button1_url'])) {
            $buttons[] = [
                'id' => 'btn1',
                'text' => $notification['button1_text'],
                'url' => $notification['button1_url']
            ];
        }
        if (!empty($notification['button2_text']) && !empty($notification['button2_url'])) {
            $buttons[] = [
                'id' => 'btn2',
                'text' => $notification['button2_text'],
                'url' => $notification['button2_url']
            ];
        }
        
        $result = send_onesignal_notification(
            $notification['title'], 
            $notification['message'], 
            $notification['image_url'], 
            $notification['action_url'], 
            $notification['platform'], 
            null, 
            $buttons
        );
        
        if ($result['success']) {
            $stmt = $pdo->prepare("
                UPDATE notifications 
                SET status = 'sent', sent_time = NOW(), user_count = ?, onesignal_id = ?
                WHERE id = ?
            ");
            $stmt->execute([$result['user_count'], $result['onesignal_id'], $notification['id']]);
            $results[] = "Notification #{$notification['id']} sent to {$result['user_count']} users";
        } else {
            $stmt = $pdo->prepare("UPDATE notifications SET status = 'failed' WHERE id = ?");
            $stmt->execute([$notification['id']]);
            $results[] = "Notification #{$notification['id']} failed: " . $result['message'];
        }
    }
    
    echo json_encode(['success'=>true, 'message'=>'Cron job completed', 'results'=>$results]);
    exit;
}

echo json_encode(['success'=>false,'message'=>'Invalid request']); 