<!-- Firebase-based Sidebar -->
<div class="sidebar" id="sidebar">
    <div class="sidebar-header">
        <div class="sidebar-logo">
            <img src="/pages/assets/logo.png" alt="Postery Logo" class="sidebar-logo-img">
        </div>
        <h3 class="sidebar-title">Postery Admin</h3>
        <p class="sidebar-subtitle">Social Media Management</p>
    </div>
    
    <nav class="sidebar-nav" aria-label="Main Navigation">
        <ul class="nav-menu">
            <li class="nav-section">DASHBOARD</li>
            <li class="nav-item">
                <a href="/index_new.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'index_new.php' ? ' active' : '' ?>" aria-label="Dashboard">
                    <i class="fas fa-tachometer-alt"></i>
                    <span class="nav-text">Dashboard</span>
                </a>
            </li>
            
            <li class="nav-section">USER MANAGEMENT</li>
            <li class="nav-item">
                <a href="/pages/users_new.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'users_new.php' ? ' active' : '' ?>" aria-label="Users">
                    <i class="fas fa-users"></i>
                    <span class="nav-text">Users</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/user_analytics_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'user_analytics_firebase.php' ? ' active' : '' ?>" aria-label="User Analytics">
                    <i class="fas fa-user-chart"></i>
                    <span class="nav-text">User Analytics</span>
                </a>
            </li>
            
            <li class="nav-section">CONTENT MANAGEMENT</li>
            <li class="nav-item">
                <a href="/pages/posts_new.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'posts_new.php' ? ' active' : '' ?>" aria-label="Posts">
                    <i class="fas fa-images"></i>
                    <span class="nav-text">Posts</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/comments_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'comments_firebase.php' ? ' active' : '' ?>" aria-label="Comments">
                    <i class="fas fa-comments"></i>
                    <span class="nav-text">Comments</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/stories_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'stories_firebase.php' ? ' active' : '' ?>" aria-label="Stories">
                    <i class="fas fa-clock"></i>
                    <span class="nav-text">Stories</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/chats_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'chats_firebase.php' ? ' active' : '' ?>" aria-label="Chats">
                    <i class="fas fa-comment-dots"></i>
                    <span class="nav-text">Chats & Messages</span>
                </a>
            </li>
            
            <li class="nav-section">MODERATION</li>
            <li class="nav-item">
                <a href="/pages/reports_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'reports_firebase.php' ? ' active' : '' ?>" aria-label="Reports">
                    <i class="fas fa-flag"></i>
                    <span class="nav-text">Reports</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/content_moderation_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'content_moderation_firebase.php' ? ' active' : '' ?>" aria-label="Content Moderation">
                    <i class="fas fa-shield-alt"></i>
                    <span class="nav-text">Content Moderation</span>
                </a>
            </li>
            
            <li class="nav-section">COMMUNICATION</li>
            <li class="nav-item">
                <a href="/pages/notifications_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'notifications_firebase.php' ? ' active' : '' ?>" aria-label="Notifications">
                    <i class="fas fa-bell"></i>
                    <span class="nav-text">Notifications</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/broadcast_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'broadcast_firebase.php' ? ' active' : '' ?>" aria-label="Broadcast Messages">
                    <i class="fas fa-bullhorn"></i>
                    <span class="nav-text">Broadcast Messages</span>
                </a>
            </li>
            
            <li class="nav-section">ANALYTICS & INSIGHTS</li>
            <li class="nav-item">
                <a href="/pages/analytics_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'analytics_firebase.php' ? ' active' : '' ?>" aria-label="Analytics">
                    <i class="fas fa-chart-line"></i>
                    <span class="nav-text">Analytics</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/insights_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'insights_firebase.php' ? ' active' : '' ?>" aria-label="Insights">
                    <i class="fas fa-lightbulb"></i>
                    <span class="nav-text">Insights</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/engagement_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'engagement_firebase.php' ? ' active' : '' ?>" aria-label="Engagement">
                    <i class="fas fa-heart"></i>
                    <span class="nav-text">Engagement</span>
                </a>
            </li>
            
            <li class="nav-section">MONETIZATION</li>
            <li class="nav-item">
                <a href="/pages/earnings_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'earnings_firebase.php' ? ' active' : '' ?>" aria-label="Earnings">
                    <i class="fas fa-dollar-sign"></i>
                    <span class="nav-text">Earnings</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/withdrawals_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'withdrawals_firebase.php' ? ' active' : '' ?>" aria-label="Withdrawals">
                    <i class="fas fa-money-bill-wave"></i>
                    <span class="nav-text">Withdrawals</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/monetization_requests_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'monetization_requests_firebase.php' ? ' active' : '' ?>" aria-label="Monetization Requests">
                    <i class="fas fa-hand-holding-usd"></i>
                    <span class="nav-text">Monetization Requests</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/ads_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'ads_firebase.php' ? ' active' : '' ?>" aria-label="Custom Ads">
                    <i class="fas fa-ad"></i>
                    <span class="nav-text">Custom Ads</span>
                </a>
            </li>
            
            <li class="nav-section">SUPPORT & FEEDBACK</li>
            <li class="nav-item">
                <a href="/pages/user_feedback_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'user_feedback_firebase.php' ? ' active' : '' ?>" aria-label="User Feedback">
                    <i class="fas fa-comment-alt"></i>
                    <span class="nav-text">User Feedback</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/problem_reports_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'problem_reports_firebase.php' ? ' active' : '' ?>" aria-label="Problem Reports">
                    <i class="fas fa-bug"></i>
                    <span class="nav-text">Problem Reports</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/account_deletions_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'account_deletions_firebase.php' ? ' active' : '' ?>" aria-label="Account Deletions">
                    <i class="fas fa-user-times"></i>
                    <span class="nav-text">Account Deletions</span>
                </a>
            </li>
            
            <li class="nav-section">SETTINGS</li>
            <li class="nav-item">
                <a href="/pages/settings_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'settings_firebase.php' ? ' active' : '' ?>" aria-label="App Settings">
                    <i class="fas fa-cog"></i>
                    <span class="nav-text">App Settings</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/monetization_config_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'monetization_config_firebase.php' ? ' active' : '' ?>" aria-label="Monetization Config">
                    <i class="fas fa-coins"></i>
                    <span class="nav-text">Monetization Config</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/pages/firebase_management_firebase.php" class="nav-link<?= basename($_SERVER['PHP_SELF']) === 'firebase_management_firebase.php' ? ' active' : '' ?>" aria-label="Firebase Management">
                    <i class="fas fa-database"></i>
                    <span class="nav-text">Firebase Management</span>
                </a>
            </li>
            
            <li class="nav-section">ACCOUNT</li>
            <li class="nav-item">
                <a href="/pages/login_new.php?logout=1" class="nav-link" aria-label="Logout">
                    <i class="fas fa-sign-out-alt"></i>
                    <span class="nav-text">Logout</span>
                </a>
            </li>
        </ul>
    </nav>
    
    <div class="sidebar-profile">
        <img src="https://ui-avatars.com/api/?name=<?= urlencode($_SESSION['admin_username'] ?? 'Admin') ?>&background=6366f1&color=fff&rounded=true&size=64" alt="Admin" class="sidebar-profile-img">
        <div class="sidebar-profile-info">
            <div class="sidebar-profile-name"><?= htmlspecialchars($_SESSION['admin_username'] ?? 'Admin') ?></div>
            <div class="sidebar-profile-role">Administrator</div>
            <div class="sidebar-profile-status">
                <span class="status-dot"></span>
                Online
            </div>
        </div>
    </div>
</div>

<!-- Overlay for mobile -->
<div class="sidebar-overlay" id="sidebarOverlay" onclick="toggleSidebar()"></div>

<!-- Mobile Toggle Button -->
<button class="sidebar-toggle" onclick="toggleSidebar()">
    <i class="fas fa-bars"></i>
</button>

<style>
/* Enhanced Sidebar Styles */
.sidebar {
    width: var(--sidebar-width);
    height: 100vh;
    background: linear-gradient(180deg, #1e293b 0%, #334155 100%);
    position: fixed;
    top: 0;
    left: 0;
    display: flex;
    flex-direction: column;
    box-shadow: 4px 0 30px rgba(0, 0, 0, 0.15);
    z-index: 1200;
    transition: transform 0.3s ease, box-shadow 0.3s;
    transform: translateX(0);
    padding-bottom: 0;
}

.sidebar-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100vw;
    height: 100vh;
    background: rgba(0, 0, 0, 0.5);
    z-index: 1100;
    transition: opacity 0.3s;
}

.sidebar-toggle {
    position: fixed;
    top: 20px;
    left: 20px;
    z-index: 1300;
    background: var(--primary);
    color: #fff;
    border: none;
    border-radius: 12px;
    padding: 12px 16px;
    font-size: 1.3rem;
    display: none;
    box-shadow: 0 4px 15px rgba(99, 102, 241, 0.3);
    transition: all 0.3s ease;
}

.sidebar-toggle:hover {
    background: var(--primary-dark);
    transform: scale(1.05);
}

@media (max-width: 900px) {
    .sidebar {
        transform: translateX(-100%);
        box-shadow: none;
        padding-bottom: 40px;
    }
    .sidebar.open {
        transform: translateX(0);
        box-shadow: 4px 0 30px rgba(0,0,0,0.3);
    }
    .sidebar-toggle {
        display: block;
    }
    .sidebar-overlay.active {
        display: block;
        opacity: 1;
    }
    .sidebar-overlay {
        display: none;
        opacity: 0;
    }
}

.sidebar-header {
    padding: 2rem 1.5rem;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    text-align: center;
    background: rgba(255, 255, 255, 0.05);
}

.sidebar-logo-img {
    max-width: 80px;
    height: auto;
    margin-bottom: 1rem;
    border-radius: 12px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
}

.sidebar-title {
    font-size: 1.3rem;
    font-weight: 700;
    color: white;
    margin: 0 0 0.3rem 0;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
}

.sidebar-subtitle {
    font-size: 0.8rem;
    color: rgba(255, 255, 255, 0.7);
    margin: 0;
    font-weight: 500;
}

.sidebar-nav {
    flex: 1;
    overflow-y: auto;
    padding: 1rem 0;
}

.nav-menu {
    list-style: none;
    padding: 0;
    margin: 0;
}

.nav-section {
    padding: 1rem 1.5rem 0.5rem;
    font-size: 0.7rem;
    text-transform: uppercase;
    letter-spacing: 1px;
    color: rgba(255, 255, 255, 0.6);
    font-weight: 700;
    margin-top: 1rem;
}

.nav-section:first-child {
    margin-top: 0;
}

.nav-item {
    margin: 0.1rem 0;
}

.nav-link {
    display: flex;
    align-items: center;
    padding: 0.9rem 1.5rem;
    color: rgba(255, 255, 255, 0.8);
    text-decoration: none;
    transition: all 0.3s ease;
    position: relative;
    border-radius: 0 25px 25px 0;
    margin-right: 1rem;
}

.nav-link:hover {
    color: white;
    background: rgba(99, 102, 241, 0.2);
    transform: translateX(5px);
}

.nav-link.active {
    color: white;
    background: linear-gradient(135deg, var(--primary), var(--secondary));
    box-shadow: 0 4px 15px rgba(99, 102, 241, 0.3);
}

.nav-link.active::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    height: 100%;
    width: 4px;
    background: white;
    border-radius: 0 2px 2px 0;
}

.nav-link i {
    font-size: 1.1rem;
    width: 24px;
    margin-right: 1rem;
    text-align: center;
}

.nav-text {
    font-size: 0.9rem;
    font-weight: 500;
}

.sidebar-profile {
    padding: 1.5rem;
    border-top: 1px solid rgba(255, 255, 255, 0.1);
    display: flex;
    align-items: center;
    background: rgba(255, 255, 255, 0.05);
}

.sidebar-profile-img {
    width: 45px;
    height: 45px;
    border-radius: 12px;
    margin-right: 1rem;
    object-fit: cover;
    border: 2px solid rgba(255, 255, 255, 0.2);
}

.sidebar-profile-info {
    line-height: 1.4;
    flex: 1;
}

.sidebar-profile-name {
    font-size: 0.95rem;
    font-weight: 600;
    color: white;
    margin-bottom: 0.2rem;
}

.sidebar-profile-role {
    font-size: 0.8rem;
    color: rgba(255, 255, 255, 0.7);
    margin-bottom: 0.3rem;
}

.sidebar-profile-status {
    display: flex;
    align-items: center;
    font-size: 0.75rem;
    color: rgba(255, 255, 255, 0.6);
}

.status-dot {
    width: 8px;
    height: 8px;
    background: #10b981;
    border-radius: 50%;
    margin-right: 0.5rem;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0% { opacity: 1; }
    50% { opacity: 0.5; }
    100% { opacity: 1; }
}

/* Animation for nav items */
@keyframes slideIn {
    from { 
        opacity: 0; 
        transform: translateX(-20px); 
    }
    to { 
        opacity: 1; 
        transform: translateX(0); 
    }
}

.nav-item {
    animation: slideIn 0.3s ease forwards;
    opacity: 0;
}

.nav-item:nth-child(1) { animation-delay: 0.1s; }
.nav-item:nth-child(2) { animation-delay: 0.15s; }
.nav-item:nth-child(3) { animation-delay: 0.2s; }
.nav-item:nth-child(4) { animation-delay: 0.25s; }
.nav-item:nth-child(5) { animation-delay: 0.3s; }
.nav-item:nth-child(6) { animation-delay: 0.35s; }
.nav-item:nth-child(7) { animation-delay: 0.4s; }
.nav-item:nth-child(8) { animation-delay: 0.45s; }
.nav-item:nth-child(9) { animation-delay: 0.5s; }
.nav-item:nth-child(10) { animation-delay: 0.55s; }
.nav-item:nth-child(11) { animation-delay: 0.6s; }
.nav-item:nth-child(12) { animation-delay: 0.65s; }
.nav-item:nth-child(13) { animation-delay: 0.7s; }
.nav-item:nth-child(14) { animation-delay: 0.75s; }
.nav-item:nth-child(15) { animation-delay: 0.8s; }
.nav-item:nth-child(16) { animation-delay: 0.85s; }
.nav-item:nth-child(17) { animation-delay: 0.9s; }
.nav-item:nth-child(18) { animation-delay: 0.95s; }
.nav-item:nth-child(19) { animation-delay: 1.0s; }
.nav-item:nth-child(20) { animation-delay: 1.05s; }
.nav-item:nth-child(21) { animation-delay: 1.1s; }
.nav-item:nth-child(22) { animation-delay: 1.15s; }
.nav-item:nth-child(23) { animation-delay: 1.2s; }
.nav-item:nth-child(24) { animation-delay: 1.25s; }
.nav-item:nth-child(25) { animation-delay: 1.3s; }
.nav-item:nth-child(26) { animation-delay: 1.35s; }
.nav-item:nth-child(27) { animation-delay: 1.4s; }
.nav-item:nth-child(28) { animation-delay: 1.45s; }
.nav-item:nth-child(29) { animation-delay: 1.5s; }
.nav-item:nth-child(30) { animation-delay: 1.55s; }
.nav-item:nth-child(31) { animation-delay: 1.6s; }
.nav-item:nth-child(32) { animation-delay: 1.65s; }
.nav-item:nth-child(33) { animation-delay: 1.7s; }
.nav-item:nth-child(34) { animation-delay: 1.75s; }
.nav-item:nth-child(35) { animation-delay: 1.8s; }
.nav-item:nth-child(36) { animation-delay: 1.85s; }
.nav-item:nth-child(37) { animation-delay: 1.9s; }
.nav-item:nth-child(38) { animation-delay: 1.95s; }
.nav-item:nth-child(39) { animation-delay: 2.0s; }
.nav-item:nth-child(40) { animation-delay: 2.05s; }
</style>

<script>
function toggleSidebar() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    const isOpen = sidebar.classList.contains('open');
    
    if (isOpen) {
        sidebar.classList.remove('open');
        overlay.classList.remove('active');
        document.body.style.overflow = '';
    } else {
        sidebar.classList.add('open');
        overlay.classList.add('active');
        document.body.style.overflow = 'hidden';
    }
}

// Hide sidebar on resize if >900px
window.addEventListener('resize', function() {
    if (window.innerWidth > 900) {
        document.getElementById('sidebar').classList.remove('open');
        document.getElementById('sidebarOverlay').classList.remove('active');
        document.body.style.overflow = '';
    }
});

// Highlight active link based on current path
(function() {
    const currentPath = window.location.pathname.split('/').pop();
    document.querySelectorAll('.nav-link').forEach(link => {
        const linkPath = link.getAttribute('href').split('/').pop();
        if (linkPath === currentPath || 
            (currentPath === 'index_firebase.php' && linkPath === 'index_firebase.php')) {
            link.classList.add('active');
        }
    });
})();

// Add smooth scrolling to sidebar
document.querySelectorAll('.nav-link').forEach(link => {
    link.addEventListener('click', function(e) {
        // Add a small delay for smooth transition
        setTimeout(() => {
            if (window.innerWidth <= 900) {
                toggleSidebar();
            }
        }, 100);
    });
});
</script>
