<?php
// Firebase Configuration for Postry Social Media App
// This file now uses production configuration without external dependencies

// Redirect to production configuration
require_once __DIR__ . '/firebase_production.php';

// For backward compatibility, create aliases
class FirebaseConfig {
    public static function getConfig() {
        return ProductionFirebaseConfig::getConfig();
    }
    
    public static function getProjectId() {
        return ProductionFirebaseConfig::getProjectId();
    }
    
    public static function getServiceAccount() {
        return ProductionFirebaseConfig::getServiceAccount();
    }
}

class FirebaseHelper {
    public static function addDocument($collection, $data) {
        return ProductionFirebaseHelper::addDocument($collection, $data);
    }
    
    public static function getDocument($collection, $documentId) {
        return ProductionFirebaseHelper::getDocument($collection, $documentId);
    }
    
    public static function updateDocument($collection, $documentId, $data) {
        return ProductionFirebaseHelper::updateDocument($collection, $documentId, $data);
    }
    
    public static function deleteDocument($collection, $documentId) {
        return ProductionFirebaseHelper::deleteDocument($collection, $documentId);
    }
    
    public static function getCollection($collection, $limit = null, $orderBy = null, $where = null) {
        return ProductionFirebaseHelper::getCollection($collection, $limit, $orderBy, $where);
    }
    
    public static function getCollectionCount($collection, $where = null) {
        return ProductionFirebaseHelper::getCollectionCount($collection, $where);
    }
    
    public static function getUsers($limit = 50, $orderBy = 'created_at', $direction = 'desc') {
        return ProductionFirebaseHelper::getUsers($limit, $orderBy, $direction);
    }
    
    public static function getUserById($userId) {
        return ProductionFirebaseHelper::getDocument('users', $userId);
    }
    
    public static function updateUser($userId, $data) {
        return ProductionFirebaseHelper::updateDocument('users', $userId, $data);
    }
    
    public static function blockUser($userId, $isBlocked = true) {
        return ProductionFirebaseHelper::updateDocument('users', $userId, ['is_blocked' => $isBlocked]);
    }
    
    public static function getPosts($limit = 50, $orderBy = 'created_at', $direction = 'desc') {
        return ProductionFirebaseHelper::getPosts($limit, $orderBy, $direction);
    }
    
    public static function getPostById($postId) {
        return ProductionFirebaseHelper::getDocument('posts', $postId);
    }
    
    public static function updatePost($postId, $data) {
        return ProductionFirebaseHelper::updateDocument('posts', $postId, $data);
    }
    
    public static function deletePost($postId) {
        return ProductionFirebaseHelper::deleteDocument('posts', $postId);
    }
    
    public static function getUserStats() {
        return ProductionFirebaseHelper::getUserStats();
    }
    
    public static function getPostStats() {
        return ProductionFirebaseHelper::getPostStats();
    }
    
    public static function searchUsers($searchTerm, $limit = 20) {
        return ProductionFirebaseHelper::searchUsers($searchTerm, $limit);
    }
    
    public static function searchPosts($searchTerm, $limit = 20) {
        return ProductionFirebaseHelper::searchPosts($searchTerm, $limit);
    }
}

// Initialize configuration
try {
    ProductionFirebaseConfig::getServiceAccount();
    error_log('Firebase configuration initialized successfully (production mode)');
} catch (Exception $e) {
    error_log('Firebase initialization failed: ' . $e->getMessage());
}
?>