<?php
// Use production Firebase configuration
require_once __DIR__ . '/firebase_production.php';

header('Content-Type: application/json');
require_firebase_auth();

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $limit = $_GET['limit'] ?? 50;
    $orderBy = $_GET['orderBy'] ?? 'created_at';
    $direction = $_GET['direction'] ?? 'desc';
    $search = $_GET['search'] ?? '';
    $status = $_GET['status'] ?? ''; // all, active, reported, deleted
    
    if (!empty($search)) {
        $posts = FirebaseHelper::searchPosts($search, $limit);
    } else {
        $where = [];
        if ($status === 'reported') {
            $where['is_reported'] = true;
        } elseif ($status === 'active') {
            $where['is_reported'] = false;
            $where['is_deleted'] = false;
        } elseif ($status === 'deleted') {
            $where['is_deleted'] = true;
        }
        
        $posts = FirebaseHelper::getCollection('posts', $limit, ['field' => $orderBy, 'direction' => $direction], $where);
    }
    
    echo json_encode(['success' => true, 'data' => $posts]);
    exit;
}

if ($method === 'GET' && isset($_GET['id'])) {
    $postId = $_GET['id'];
    $post = FirebaseHelper::getPostById($postId);
    
    if ($post) {
        echo json_encode(['success' => true, 'data' => $post]);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Post not found']);
    }
    exit;
}

if ($method === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    
    $postData = [
        'user_id' => $data['user_id'] ?? '',
        'content' => $data['content'] ?? '',
        'media_urls' => $data['media_urls'] ?? [],
        'media_type' => $data['media_type'] ?? 'text', // text, image, video, audio
        'location' => $data['location'] ?? '',
        'hashtags' => $data['hashtags'] ?? [],
        'mentions' => $data['mentions'] ?? [],
        'likes_count' => $data['likes_count'] ?? 0,
        'comments_count' => $data['comments_count'] ?? 0,
        'shares_count' => $data['shares_count'] ?? 0,
        'views_count' => $data['views_count'] ?? 0,
        'is_reported' => $data['is_reported'] ?? false,
        'is_deleted' => $data['is_deleted'] ?? false,
        'report_reason' => $data['report_reason'] ?? '',
        'created_at' => date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s')
    ];
    
    $postId = FirebaseHelper::addDocument('posts', $postData);
    
    if ($postId) {
        echo json_encode(['success' => true, 'id' => $postId, 'message' => 'Post created successfully']);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to create post']);
    }
    exit;
}

if ($method === 'PUT') {
    $postId = $_GET['id'] ?? null;
    if (!$postId) {
        http_response_code(400);
        echo json_encode(['error' => 'Post ID required']);
        exit;
    }
    
    $data = json_decode(file_get_contents('php://input'), true);
    
    $updateData = [];
    $allowedFields = [
        'content', 'media_urls', 'media_type', 'location', 'hashtags', 'mentions',
        'likes_count', 'comments_count', 'shares_count', 'views_count',
        'is_reported', 'is_deleted', 'report_reason'
    ];
    
    foreach ($allowedFields as $field) {
        if (isset($data[$field])) {
            $updateData[$field] = $data[$field];
        }
    }
    
    if (empty($updateData)) {
        http_response_code(400);
        echo json_encode(['error' => 'No fields to update']);
        exit;
    }
    
    $success = FirebaseHelper::updatePost($postId, $updateData);
    
    if ($success) {
        echo json_encode(['success' => true, 'message' => 'Post updated successfully']);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to update post']);
    }
    exit;
}

if ($method === 'DELETE') {
    $postId = $_GET['id'] ?? null;
    if (!$postId) {
        http_response_code(400);
        echo json_encode(['error' => 'Post ID required']);
        exit;
    }
    
    $success = FirebaseHelper::deletePost($postId);
    
    if ($success) {
        echo json_encode(['success' => true, 'message' => 'Post deleted successfully']);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to delete post']);
    }
    exit;
}

if ($method === 'POST' && isset($_GET['action'])) {
    $action = $_GET['action'];
    $postId = $_GET['id'] ?? null;
    
    if (!$postId) {
        http_response_code(400);
        echo json_encode(['error' => 'Post ID required']);
        exit;
    }
    
    switch ($action) {
        case 'report':
            $data = json_decode(file_get_contents('php://input'), true);
            $reason = $data['reason'] ?? 'Inappropriate content';
            
            $success = FirebaseHelper::updatePost($postId, [
                'is_reported' => true,
                'report_reason' => $reason
            ]);
            
            if ($success) {
                echo json_encode(['success' => true, 'message' => 'Post reported successfully']);
            } else {
                http_response_code(500);
                echo json_encode(['error' => 'Failed to report post']);
            }
            break;
            
        case 'unreport':
            $success = FirebaseHelper::updatePost($postId, [
                'is_reported' => false,
                'report_reason' => ''
            ]);
            
            if ($success) {
                echo json_encode(['success' => true, 'message' => 'Post report removed successfully']);
            } else {
                http_response_code(500);
                echo json_encode(['error' => 'Failed to remove post report']);
            }
            break;
            
        case 'hide':
            $success = FirebaseHelper::updatePost($postId, ['is_deleted' => true]);
            
            if ($success) {
                echo json_encode(['success' => true, 'message' => 'Post hidden successfully']);
            } else {
                http_response_code(500);
                echo json_encode(['error' => 'Failed to hide post']);
            }
            break;
            
        case 'unhide':
            $success = FirebaseHelper::updatePost($postId, ['is_deleted' => false]);
            
            if ($success) {
                echo json_encode(['success' => true, 'message' => 'Post unhidden successfully']);
            } else {
                http_response_code(500);
                echo json_encode(['error' => 'Failed to unhide post']);
            }
            break;
            
        default:
            http_response_code(400);
            echo json_encode(['error' => 'Invalid action']);
            break;
    }
    exit;
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);
?>
