<?php
// Use production Firebase configuration
require_once __DIR__ . '/firebase_production.php';

header('Content-Type: application/json');
require_firebase_auth();

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $limit = $_GET['limit'] ?? 50;
    $orderBy = $_GET['orderBy'] ?? 'created_at';
    $direction = $_GET['direction'] ?? 'desc';
    $search = $_GET['search'] ?? '';
    
    if (!empty($search)) {
        $users = FirebaseHelper::searchUsers($search, $limit);
    } else {
        $users = FirebaseHelper::getUsers($limit, $orderBy, $direction);
    }
    
    echo json_encode(['success' => true, 'data' => $users]);
    exit;
}

if ($method === 'GET' && isset($_GET['id'])) {
    $userId = $_GET['id'];
    $user = FirebaseHelper::getUserById($userId);
    
    if ($user) {
        echo json_encode(['success' => true, 'data' => $user]);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'User not found']);
    }
    exit;
}

if ($method === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    
    $userData = [
        'email' => $data['email'] ?? '',
        'username' => $data['username'] ?? '',
        'full_name' => $data['full_name'] ?? '',
        'profile_picture' => $data['profile_picture'] ?? '',
        'bio' => $data['bio'] ?? '',
        'is_verified' => $data['is_verified'] ?? false,
        'is_blocked' => $data['is_blocked'] ?? false,
        'followers_count' => $data['followers_count'] ?? 0,
        'following_count' => $data['following_count'] ?? 0,
        'posts_count' => $data['posts_count'] ?? 0,
        'device_id' => $data['device_id'] ?? '',
        'fcm_token' => $data['fcm_token'] ?? '',
        'last_active' => date('Y-m-d H:i:s'),
        'created_at' => date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s')
    ];
    
    $userId = FirebaseHelper::addDocument('users', $userData);
    
    if ($userId) {
        echo json_encode(['success' => true, 'id' => $userId, 'message' => 'User created successfully']);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to create user']);
    }
    exit;
}

if ($method === 'PUT') {
    $userId = $_GET['id'] ?? null;
    if (!$userId) {
        http_response_code(400);
        echo json_encode(['error' => 'User ID required']);
        exit;
    }
    
    $data = json_decode(file_get_contents('php://input'), true);
    
    $updateData = [];
    $allowedFields = [
        'username', 'full_name', 'profile_picture', 'bio', 'is_verified', 
        'is_blocked', 'followers_count', 'following_count', 'posts_count',
        'device_id', 'fcm_token', 'last_active'
    ];
    
    foreach ($allowedFields as $field) {
        if (isset($data[$field])) {
            $updateData[$field] = $data[$field];
        }
    }
    
    if (empty($updateData)) {
        http_response_code(400);
        echo json_encode(['error' => 'No fields to update']);
        exit;
    }
    
    $success = FirebaseHelper::updateUser($userId, $updateData);
    
    if ($success) {
        echo json_encode(['success' => true, 'message' => 'User updated successfully']);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to update user']);
    }
    exit;
}

if ($method === 'DELETE') {
    $userId = $_GET['id'] ?? null;
    if (!$userId) {
        http_response_code(400);
        echo json_encode(['error' => 'User ID required']);
        exit;
    }
    
    $success = FirebaseHelper::deleteDocument('users', $userId);
    
    if ($success) {
        echo json_encode(['success' => true, 'message' => 'User deleted successfully']);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to delete user']);
    }
    exit;
}

if ($method === 'POST' && isset($_GET['action'])) {
    $action = $_GET['action'];
    $userId = $_GET['id'] ?? null;
    
    if (!$userId) {
        http_response_code(400);
        echo json_encode(['error' => 'User ID required']);
        exit;
    }
    
    switch ($action) {
        case 'block':
            $success = FirebaseHelper::blockUser($userId, true);
            if ($success) {
                echo json_encode(['success' => true, 'message' => 'User blocked successfully']);
            } else {
                http_response_code(500);
                echo json_encode(['error' => 'Failed to block user']);
            }
            break;
            
        case 'unblock':
            $success = FirebaseHelper::blockUser($userId, false);
            if ($success) {
                echo json_encode(['success' => true, 'message' => 'User unblocked successfully']);
            } else {
                http_response_code(500);
                echo json_encode(['error' => 'Failed to unblock user']);
            }
            break;
            
        case 'verify':
            $success = FirebaseHelper::updateUser($userId, ['is_verified' => true]);
            if ($success) {
                echo json_encode(['success' => true, 'message' => 'User verified successfully']);
            } else {
                http_response_code(500);
                echo json_encode(['error' => 'Failed to verify user']);
            }
            break;
            
        case 'unverify':
            $success = FirebaseHelper::updateUser($userId, ['is_verified' => false]);
            if ($success) {
                echo json_encode(['success' => true, 'message' => 'User verification removed successfully']);
            } else {
                http_response_code(500);
                echo json_encode(['error' => 'Failed to remove user verification']);
            }
            break;
            
        default:
            http_response_code(400);
            echo json_encode(['error' => 'Invalid action']);
            break;
    }
    exit;
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);
?>
