<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/token.php';

header('Content-Type: application/json');
$admin = require_auth(); // This now enforces Authorization header or session
$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? '';

if ($method === 'GET' && $action === 'list') {
    // Return promo codes with usage count
    $stmt = $pdo->query('SELECT pc.*, (SELECT COUNT(*) FROM promo_code_usage pcu WHERE pcu.promo_code_id = pc.id) as used FROM promo_codes pc ORDER BY pc.id DESC');
    echo json_encode(['promos' => $stmt->fetchAll()]);
    exit;
}

if ($method === 'GET' && $action === 'usage' && isset($_GET['promo_id'])) {
    $promo_id = (int)$_GET['promo_id'];
    $stmt = $pdo->prepare('SELECT pcu.*, u.email FROM promo_code_usage pcu LEFT JOIN users u ON pcu.user_id = u.id WHERE pcu.promo_code_id = ? ORDER BY pcu.created_at DESC');
    $stmt->execute([$promo_id]);
    $usage = $stmt->fetchAll();
    echo json_encode(['success' => true, 'usage' => $usage]);
    exit;
}

if ($method === 'GET') {
    // fallback: legacy, return all promo codes (no usage count)
    $stmt = $pdo->query('SELECT * FROM promo_codes ORDER BY id DESC');
    echo json_encode(['data' => $stmt->fetchAll()]);
    exit;
}

if ($method === 'POST') {
    $action = $_POST['action'] ?? '';
    if ($action === 'add') {
        $code = $_POST['code'] ?? '';
        $coins = $_POST['coins'] ?? '';
        $usage_limit = $_POST['usage_limit'] ?? 0;
        $expiry_date = $_POST['expiry_date'] ?? null;
        if (!$code || !$coins || !$usage_limit || !$expiry_date) {
            http_response_code(400);
            echo json_encode(['error' => 'All fields required']);
            exit;
        }
        $stmt = $pdo->prepare('INSERT INTO promo_codes (code, coins, usage_limit, expiry_date) VALUES (?, ?, ?, ?)');
        $stmt->execute([$code, $coins, $usage_limit, $expiry_date]);
        echo json_encode(['success' => true, 'id' => $pdo->lastInsertId()]);
        exit;
    } elseif ($action === 'edit') {
        $id = $_POST['promo_id'] ?? null;
        $code = $_POST['code'] ?? '';
        $coins = $_POST['coins'] ?? '';
        $usage_limit = $_POST['usage_limit'] ?? 0;
        $expiry_date = $_POST['expiry_date'] ?? null;
        if (!$id || !$code || !$coins || !$usage_limit || !$expiry_date) {
            http_response_code(400);
            echo json_encode(['error' => 'All fields required']);
            exit;
        }
        $stmt = $pdo->prepare('UPDATE promo_codes SET code=?, coins=?, usage_limit=?, expiry_date=? WHERE id=?');
        $stmt->execute([$code, $coins, $usage_limit, $expiry_date, $id]);
        echo json_encode(['success' => true]);
        exit;
    } elseif ($action === 'delete') {
        $id = $_POST['promo_id'] ?? null;
        if (!$id) {
            http_response_code(400);
            echo json_encode(['error' => 'Missing promo id']);
            exit;
        }
        $stmt = $pdo->prepare('DELETE FROM promo_codes WHERE id=?');
        $stmt->execute([$id]);
        echo json_encode(['success' => true]);
        exit;
    }
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']); 