<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/token.php';

header('Content-Type: application/json');
$admin = require_auth();
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $id = $_GET['id'] ?? null;
    if ($id) {
        $stmt = $pdo->prepare('SELECT h.*, u.email as user_email, s.sub_category_name, c.category_name FROM redeem_history h LEFT JOIN users u ON h.user_id = u.id LEFT JOIN redeem_options_subcategories s ON h.subcategory_id = s.id LEFT JOIN redeem_options_categories c ON s.category_id = c.id WHERE h.id = ?');
        $stmt->execute([$id]);
        echo json_encode(['data' => $stmt->fetch()]);
        exit;
    }
    // Filtering (user, status, category, date)
    $where = [];
    $params = [];
    if (!empty($_GET['status'])) { $where[] = 'h.status = ?'; $params[] = $_GET['status']; }
    if (!empty($_GET['user'])) { $where[] = 'u.email LIKE ?'; $params[] = '%' . $_GET['user'] . '%'; }
    if (!empty($_GET['category'])) { $where[] = 'c.id = ?'; $params[] = $_GET['category']; }
    if (!empty($_GET['date'])) { $where[] = 'DATE(h.created_at) = ?'; $params[] = $_GET['date']; }
    $sql = 'SELECT h.*, u.email as user_email, s.sub_category_name, c.category_name FROM redeem_history h LEFT JOIN users u ON h.user_id = u.id LEFT JOIN redeem_options_subcategories s ON h.subcategory_id = s.id LEFT JOIN redeem_options_categories c ON s.category_id = c.id';
    if ($where) $sql .= ' WHERE ' . implode(' AND ', $where);
    $sql .= ' ORDER BY h.id DESC';
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    echo json_encode(['data' => $stmt->fetchAll()]);
    exit;
}

if ($method === 'POST') {
    $id = $_POST['id'] ?? null;
    $status = $_POST['status'] ?? null;
    $rejection_reason = $_POST['rejection_reason'] ?? null;
    if (!$id || !$status) {
        http_response_code(400);
        echo json_encode(['error' => 'ID and status required']);
        exit;
    }
    $fields = ['status = ?'];
    $params = [$status];
    if ($status === 'rejected') {
        $fields[] = 'rejection_reason = ?';
        $params[] = $rejection_reason;
    } else {
        $fields[] = 'rejection_reason = NULL';
    }
    $params[] = $id;
    $sql = 'UPDATE redeem_history SET ' . implode(', ', $fields) . ' WHERE id = ?';
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    echo json_encode(['success' => true]);
    exit;
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']); 