<?php
// Test Firebase Connection
echo "🔥 Testing Firebase Connection...\n\n";

try {
    // Test if service account key exists
    if (!file_exists(__DIR__ . '/serviceAccountKey.json')) {
        throw new Exception('Service account key file not found!');
    }
    echo "✅ Service account key file found\n";

    // Test if composer autoload exists
    if (!file_exists(__DIR__ . '/vendor/autoload.php')) {
        echo "⚠️  Composer dependencies not installed. Please run: composer install\n";
        echo "   Or manually download Firebase PHP SDK\n\n";
    } else {
        require_once __DIR__ . '/vendor/autoload.php';
        echo "✅ Composer autoload found\n";
    }

    // Test Firebase configuration
    require_once __DIR__ . '/firebase_config.php';
    echo "✅ Firebase configuration loaded\n";

    // Test Firebase connection
    $firestore = FirebaseConfig::getFirestore();
    echo "✅ Firebase Firestore connection successful!\n";

    // Display project info
    echo "\n📊 Project Information:\n";
    echo "   Project ID: " . FirebaseConfig::FIREBASE_CONFIG['projectId'] . "\n";
    echo "   Auth Domain: " . FirebaseConfig::FIREBASE_CONFIG['authDomain'] . "\n";
    echo "   Storage Bucket: " . FirebaseConfig::FIREBASE_CONFIG['storageBucket'] . "\n";

    // Test basic Firestore operation
    echo "\n🧪 Testing Firestore operations...\n";
    
    // Try to get a test document (this will work even if collection doesn't exist)
    $testDoc = FirebaseHelper::getDocument('test', 'connection_test');
    echo "✅ Firestore read operation successful\n";

    // Test adding a document
    $testData = [
        'test_field' => 'connection_test',
        'timestamp' => date('Y-m-d H:i:s'),
        'status' => 'success'
    ];
    
    $docId = FirebaseHelper::addDocument('test', $testData);
    if ($docId) {
        echo "✅ Firestore write operation successful (Document ID: $docId)\n";
        
        // Clean up test document
        FirebaseHelper::deleteDocument('test', $docId);
        echo "✅ Test document cleaned up\n";
    }

    echo "\n🎉 All Firebase tests passed!\n";
    echo "🚀 Your admin panel is ready to use!\n\n";

    echo "📋 Next Steps:\n";
    echo "1. Create admin user: POST /backend/firebase_auth.php?action=create_admin\n";
    echo "2. Login: POST /backend/firebase_auth.php?action=login\n";
    echo "3. Test dashboard: GET /backend/firebase_dashboard.php\n\n";

} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n\n";
    
    echo "🔧 Troubleshooting:\n";
    echo "1. Make sure serviceAccountKey.json is in backend folder\n";
    echo "2. Install composer dependencies: composer install\n";
    echo "3. Check Firebase project permissions\n";
    echo "4. Verify internet connection\n\n";
}

echo "📖 For detailed setup instructions, see: QUICK_SETUP_GUIDE.md\n";
?>
