<?php
// Test Production Firebase Configuration
echo "🚀 Testing Production Firebase Configuration...\n\n";

try {
    // Test production configuration
    require_once __DIR__ . '/firebase_production.php';
    echo "✅ Production Firebase configuration loaded\n";
    
    // Test service account
    $serviceAccount = ProductionFirebaseConfig::getServiceAccount();
    echo "✅ Service account loaded (Project: " . $serviceAccount['project_id'] . ")\n";
    
    // Test helper functions
    $userStats = ProductionFirebaseHelper::getUserStats();
    echo "✅ User stats: " . json_encode($userStats) . "\n";
    
    $postStats = ProductionFirebaseHelper::getPostStats();
    echo "✅ Post stats: " . json_encode($postStats) . "\n";
    
    // Test getting users
    $users = ProductionFirebaseHelper::getUsers(5);
    echo "✅ Retrieved " . count($users) . " users\n";
    
    // Test getting posts
    $posts = ProductionFirebaseHelper::getPosts(5);
    echo "✅ Retrieved " . count($posts) . " posts\n";
    
    // Test document operations
    $docId = ProductionFirebaseHelper::addDocument('test', ['test' => 'data']);
    echo "✅ Added test document: $docId\n";
    
    $doc = ProductionFirebaseHelper::getDocument('test', $docId);
    echo "✅ Retrieved test document: " . json_encode($doc) . "\n";
    
    $updated = ProductionFirebaseHelper::updateDocument('test', $docId, ['updated' => true]);
    echo "✅ Updated test document: " . ($updated ? 'success' : 'failed') . "\n";
    
    $deleted = ProductionFirebaseHelper::deleteDocument('test', $docId);
    echo "✅ Deleted test document: " . ($deleted ? 'success' : 'failed') . "\n";
    
    echo "\n🎉 All production tests passed!\n";
    echo "🚀 Your admin panel is ready for production!\n\n";
    
    echo "📋 Available API Endpoints:\n";
    echo "• POST /backend/firebase_auth.php?action=login\n";
    echo "• GET /backend/firebase_dashboard.php\n";
    echo "• GET /backend/firebase_users.php\n";
    echo "• GET /backend/firebase_posts.php\n";
    echo "• GET /backend/firebase_analytics.php?action=overview\n";
    echo "• GET /backend/firebase_notifications.php\n";
    echo "• GET /backend/firebase_settings.php\n\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n\n";
    
    echo "🔧 Troubleshooting:\n";
    echo "1. Check serviceAccountKey.json file exists\n";
    echo "2. Verify Firebase project permissions\n";
    echo "3. Check internet connection\n";
    echo "4. Review error logs\n\n";
}

echo "🎯 Project: Postry Social Media Admin Panel\n";
echo "🔥 Backend: Production Firebase Configuration\n";
echo "📱 Status: Ready for Production Use\n\n";
?>
